//
//  RVNetworkTCPClientHardwareCommunicator.h
//  CommunicationModule
//
//  Created by Greg Harris on 7/25/12.
//  Copyright (c) 2012 Renewed Vision, LLC. All rights reserved.
//

#import "RVNetworkHardwareCommunicator.h"

@class RVGCDAsyncSocket;
@protocol RVTCPNetworkProtocolParser;

extern NSString *RVTCPNetworkSerializationKeyAttributeInterface;
extern NSString *RVTCPNetworkSerializationKeyAttributeMode;
extern NSString *RVTCPNetworkSerializationKeyAttributeAddress;
extern NSString *RVTCPNetworkSerializationKeyAttributePort;

typedef NS_ENUM(NSInteger, RVTCPNetworkOptionMode){
	RVTCPNetworkOptionModeConnectTo = 1,
	RVTCPNetworkOptionModeAcceptOn = 2,
};

@interface RVTCPNetworkHardwareCommunicator : RVNetworkHardwareCommunicator {
	dispatch_queue_t delegateQueue;
	RVGCDAsyncSocket *socket;
	NSMutableDictionary *connectedSockets;
	RVTCPNetworkOptionMode socketMode;

	IBOutlet NSView *setupView;
	IBOutlet NSPopUpButton *actionPopupButton, *interfacePopupButton;
	IBOutlet NSTextField *addressField, *portField;
	IBOutlet NSButton *goButton;
}

@property (assign) RVTCPNetworkOptionMode socketMode;

- (RVProtocolParser <RVTCPNetworkProtocolParser> *)parser;
- (void) connectToHost:(NSString *)hostname onPort:(NSUInteger)port viaInterface:(NSString *)interface;
- (void) acceptOnInterface:(NSString *)interface port:(uint16_t)port;
- (void) disconnect;

- (void) readWithTimeout:(NSTimeInterval)timeout;
- (void) writeData:(NSData *)data withTimeout:(NSTimeInterval)timeout;

- (void) readHeaderOnConnection:(NSString *)identifier withTimeout:(NSTimeInterval)timeout;
- (void) readPayloadOnConnection:(NSString *)identifier withTimeout:(NSTimeInterval)timeout;
- (void) readPayloadOfLength:(NSUInteger)length onConnection:(NSString *)identifier withTimeout:(NSTimeInterval)timeout;
- (void) writeData:(NSData *)data onConnection:(NSString *)identifier withTimeout:(NSTimeInterval)timeout;

- (IBAction) goButtonAction:(id)sender;

@end

@protocol RVTCPNetworkProtocolParser

- (NSData *) networkHeaderDelimiterForNetworkHardware:(RVTCPNetworkHardwareCommunicator *)hw;
- (NSUInteger) networkHeaderLengthForNetworkHardware:(RVTCPNetworkHardwareCommunicator *)hw;

- (NSData *) networkPayloadDelimiterForNetworkHardware:(RVTCPNetworkHardwareCommunicator *)hw;
- (NSUInteger) networkPayloadLengthForNetworkHardware:(RVTCPNetworkHardwareCommunicator *)hw;

- (void) networkHardware:(RVTCPNetworkHardwareCommunicator *)hw acceptedNewConnection:(NSString *)identifier;
- (void) networkHardware:(RVTCPNetworkHardwareCommunicator *)hw readHeader:(NSData *)data fromConnection:(NSString *)identifier;
- (void) networkHardware:(RVTCPNetworkHardwareCommunicator *)hw readData:(NSData *)data fromConnection:(NSString *)identifier;

@optional
- (void) networkHardware:(RVTCPNetworkHardwareCommunicator *)hw connectionClosed:(NSString *)identifier;

- (NSTimeInterval) networkHardware:(RVTCPNetworkHardwareCommunicator *)hw readShouldTimeoutFromConnection:(NSString *)identifier;
- (NSTimeInterval) networkHardware:(RVTCPNetworkHardwareCommunicator *)hw writeShouldTimeoutFromConnection:(NSString *)identifier;

- (NSUInteger) preferredTCPPortForNetworkHardware:(RVTCPNetworkHardwareCommunicator *)hw;
- (BOOL) allowTCPSocketConnectToForNetworkHardware:(RVTCPNetworkHardwareCommunicator *)hw;
- (BOOL) allowTCPSocketAcceptFromForNetworkHardware:(RVTCPNetworkHardwareCommunicator *)hw;

- (void) networkHardwareDidConnect:(RVTCPNetworkHardwareCommunicator *)hw;
- (void) networkHardwareDidStartAccepting:(RVTCPNetworkHardwareCommunicator *)hw;
- (void) networkHardwareDidDisconnect:(RVTCPNetworkHardwareCommunicator *)hw;

@end
